package gov.va.med.mhv.getcare.repository;

import gov.va.med.mhv.getcare.model.HealthInsurance;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface HealthInsuranceRepository extends JpaRepository<HealthInsurance, Long> {

	@Query("select h from HealthInsurance h where h.userProfileId = :userProfileId order by UPPER(h.companyName) asc")
	public List<HealthInsurance> findInsurancesForUser(@Param("userProfileId") Long userProfileId);
	
	@Query("select h from HealthInsurance h where h.userProfileId = :userProfileId order by UPPER(h.companyName) asc")
	public List<HealthInsurance> findDashBoardInsurancesForUser(@Param("userProfileId") Long userProfileId,Pageable page);
	
	
	@Query("select h from HealthInsurance h where h.userProfileId = :userProfileId and h.primaryInd = 1")
	public List<HealthInsurance> findPrimaryInsurarance(@Param("userProfileId") Long userProfileId);
	
}